<?=Form::open()?>
<div class="col-md-12 well">
    <div class="row-fluid">
        <div class="col-xs-2 pull-right">
            <div class="btn-group pull-right" role="group">
                <a class="btn btn-primary" href="/email/download_all"><span class="glyphicon glyphicon-download-alt"></span> all</a>
                <?=Form::button('download_filter', '<span class="glyphicon glyphicon-download-alt"></span> filter', [
                    'class'=>'btn btn-primary',
                    'type'=>'submit'
                ]);?>
            </div>
        </div>

        <!-- Email domain -->
        <div class="col-xs-2">
            <?=Form::input('email', Arr::get($post, 'email'), [
                'id' => 'email',
                'class'=>'form-control input-sm',
                'placeholder' => 'Email'
            ]);?>
        </div>

        <!-- Referrer -->
        <div class="col-xs-2">
            <?=Form::input('referrer', Arr::get($post, 'referrer'), [
                'id' => 'referrer',
                'class'=>'form-control input-sm',
                'placeholder' => 'Referrer'
            ]);?>
        </div>

        <!-- Client -->
        <div class="col-xs-2">
            <?=Form::input('client', Arr::get($post, 'client'), [
            'class'=>'form-control input-sm',
            'placeholder' => 'Client'
            ]);?>
        </div>
    </div>


    <div class="row-fluid" style="margin-top: 40px; height: 30px;">
        <div class="col-xs-2 pull-right">
            <div class="btn-group pull-right" role="group">
                <?=Form::button('reset', 'Reset', [
                    'class'=>'btn btn-danger',
                    'type'=>'submit',
                ]);?>
                <?=Form::button('filter', 'Apply', [
                    'id' => 'filter',
                    'class'=>'btn btn-primary',
                    'type'=>'submit'
                ]);?>
            </div>
        </div>

        <!-- Locations -->
        <div id="locations_js" class="col-xs-2">
            <div class="form-group">
                <div class="clearfix">
                    <?= Form::select('locations[]', $locations, Arr::get($post, 'locations'), [
                        'class' => 'selectpicker',
                        'multiple' => '',
                        'style' => 'width: 100%; width: calc(100% - 30px);'
                    ]); ?>
                </div>
            </div>
        </div>

        <!-- Suffix -->
        <div id="locations_js" class="col-xs-2">
            <div class="form-group">
                <div class="clearfix">
                    <?= Form::select('suffix[]', $suffix, Arr::get($post, 'suffix'), [
                        'class' => 'selectpicker',
                        'multiple' => '',
                        'style' => 'width: 100%; width: calc(100% - 30px);'
                    ]); ?>
                </div>
            </div>
        </div>

        <!-- Data range -->
        <div class="col-xs-2 input-daterange input-group datepicker-range">
            <?=Form::input('date_start', Arr::get($post, 'date_start'), [
                'id' => 'date_start',
                'class' => 'form-control input-sm',
                'placeholder' => '1901/12/13'
            ]); ?>

            <span class="input-group-addon"> / </span>

            <?=Form::input('date_end', Arr::get($post, 'date_end'), [
                'id' => 'date_end',
                'class' => 'form-control input-sm',
                'placeholder' => '2038/01/19'
            ]); ?>
        </div>
    </div>
</div>
<?=Form::close()?>

<div class="col-md-12">
    <table class="table table-condensed">
        <thead style="font-weight: bold;background-color: #d9edf7;">
            <tr class="panel-heading">
                <td class="col-md-1">Email</td>
                <td>Client</td>
                <td>Location</td>
                <td>DateTime</td>
                <td>Referer</td>
            </tr>
        </thead>
        <tbody>
            <?foreach ($index as $i){?>
                <tr>
                    <td>
                        <?=$i['email']?>
                    </td>
                    <td style="white-space: nowrap;">
                        <a href="/logpost/more/<?=$i['client'].'/'.$i['id']?>" target="_blank">
                            <?=$i['prefix.client']?>
                        </a>
                    </td>
                    <td>
                        <?=$i['location']?>
                    </td>
                    <td>
                        <?=$i['datetime']?>
                    </td>
                    <td style="word-break: break-all;">
                        <?=$i['referer']?>
                    </td>
                </tr>
            <?}?>
        </tbody>
    </table>
    <?=$pagination?>
</div>

<script>
    var $selectLocations = $('select[name="locations[]"]');
    $selectLocations.select2({
        placeholder: "Location"
    }).data('select2').$container.addClass("input-sm").css('padding', 0);

    var $selectLocations = $('select[name="suffix[]"]');
    $selectLocations.select2({
        placeholder: "Suffix"
    }).data('select2').$container.addClass("input-sm").css('padding', 0);

    $('.selectpicker').selectpicker({
        style: 'btn-default btn-sm'
    });

    $('.datepicker-range').datepicker({
        language: "ru",
        autoclose: true,
        todayHighlight: true,
        format: "yyyy/mm/dd"
    });
</script>